//
//  TransactionOptionsViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 22.02.23.
//

import UIKit

class TransactionOptionsViewController : UIViewController {
    
    
    @IBOutlet var standardTransactionLabel: UILabel!
    @IBOutlet var standardTransactionLabelImageView: UIImageView!
    
    @IBOutlet var qrCodeTransactionLabel: UILabel!
    
    @IBOutlet var qrCodeTransactionImageView: UIImageView!
    
    
    
    let standardTransactionString = NSMutableAttributedString.init(string: "New Transfer\nStandard SEPA Transfer") // "Neue Überweisung\nStandard SEPA-Überweisung"
    
    let qrCodeTransactionString = NSMutableAttributedString.init(string: "QR Code Scan\nTransfer with Banking QR Code") // "QR-Code Scanner\nÜberweisung mit Banking QR-Code"
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        /*###Standard Transaction###*/
        standardTransactionLabel.numberOfLines = 0
        standardTransactionLabel.lineBreakMode = .byTruncatingTail
        
        
        standardTransactionString.setAttributes([NSAttributedString.Key.font: UIFont.systemFont(ofSize: 16, weight: .semibold),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 13)) // 16
        
        standardTransactionLabel.attributedText = standardTransactionString
        
        let guestureRecognizerStandardTransaction = UITapGestureRecognizer(target: self, action: #selector(standardTransactionClicked(_:)))
        standardTransactionLabel.isUserInteractionEnabled = true
        standardTransactionLabel.addGestureRecognizer(guestureRecognizerStandardTransaction)
        
        
        /*###QR Code Scanner###*/
        qrCodeTransactionLabel.numberOfLines = 0
        qrCodeTransactionLabel.lineBreakMode = .byTruncatingTail

        
        qrCodeTransactionString.setAttributes([NSAttributedString.Key.font: UIFont.systemFont(ofSize: 16, weight: .semibold),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 13)) //
        
        qrCodeTransactionLabel.attributedText = qrCodeTransactionString
        
        
        let guestureRecognizerQRCodeTransaction = UITapGestureRecognizer(target: self, action: #selector(qrCodeTransactionClicked(_:)))
        qrCodeTransactionLabel.isUserInteractionEnabled = true
        qrCodeTransactionLabel.addGestureRecognizer(guestureRecognizerQRCodeTransaction)
        
        
        enableButtonTransaction()

    }
    
    
    @objc func standardTransactionClicked(_ sender: Any) {
        
        // start new transaction timer
        TimerManager.shared.startTimer_NewTransaction()
        
        let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionRecipientNC") as! UINavigationController
        
        nc.modalPresentationStyle = .fullScreen
        nc.modalTransitionStyle = .coverVertical
        
        present(nc, animated: true)
        
    }
    
    @objc func qrCodeTransactionClicked(_ sender: Any) {
        
        // start new transaction timer
        TimerManager.shared.startTimer_NewTransaction()
        
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "QRCodeScannerVC") as! UIViewController
        
        self.view.window?.rootViewController = vc
        self.view.window?.makeKeyAndVisible()
    }
    
    func enableButtonTransaction() {
        standardTransactionLabel.isUserInteractionEnabled = true
        qrCodeTransactionLabel.isUserInteractionEnabled = true
        
        
        let defaults = UserDefaults.standard
        if defaults.object(forKey: "allowBothTransactionTypesAndRealWorldIBANs") != nil {
            let value = defaults.bool(forKey: "allowBothTransactionTypesAndRealWorldIBANs")
            allowBothTransactionTypesAndRealWorldIBANsPublic = value
        }
        
        if (scenarioPublic == 1 || scenarioPublic == 2) && !allowBothTransactionTypesAndRealWorldIBANsPublic && appPINPublic != "926405"{
            print("Scenario 1 or 2")
            qrCodeTransactionLabel.isUserInteractionEnabled = false
            qrCodeTransactionLabel.textColor = .lightGray
            
            qrCodeTransactionString.setAttributes([NSAttributedString.Key.font: UIFont.systemFont(ofSize: 16, weight: .semibold),
                                                   NSAttributedString.Key.foregroundColor: Colors.greyColor],
                                       range: NSMakeRange(0, 15))
            
            qrCodeTransactionLabel.attributedText = qrCodeTransactionString
            
            
            qrCodeTransactionLabel.alpha = 0.5
            
            
            
        } else if (scenarioPublic == 3 || scenarioPublic == 4) && !allowBothTransactionTypesAndRealWorldIBANsPublic && appPINPublic != "926405"{
            print("Scenario 3 or 4")
            standardTransactionLabel.isUserInteractionEnabled = false
            standardTransactionLabel.textColor = .lightGray
            
            standardTransactionString.setAttributes([NSAttributedString.Key.font: UIFont.systemFont(ofSize: 16, weight: .semibold),
                                        NSAttributedString.Key.foregroundColor: Colors.greyColor],
                                       range: NSMakeRange(0, 16))
            
            standardTransactionLabel.attributedText = standardTransactionString
            
            standardTransactionLabelImageView.alpha = 0.5
            
        } else {
            print("Scenario 5 or allowBothTransactionTypesAndRealWorldIBANsPublic is set to true")
            standardTransactionLabel.isUserInteractionEnabled = true
            qrCodeTransactionLabel.isUserInteractionEnabled = true
        }
        
    }
    
    
    
    override func viewDidLayoutSubviews() {
                super.viewDidLayoutSubviews()
                
        
         }
         
}
